<?php

namespace App\Models\QuizQuestion;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class QuizQuestion extends Model 
{

    protected $table = 'quiz_question';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('quiz_id', 'question', 'status');

    public function quiz()
    {
        return $this->belongsTo('Quiz', 'quiz_id');
    }

}